#include "ad8370.h"
#include <msp430.h>
#include <inttypes.h>

void ad8370_sw_spi_write(uint32_t data) {
	int i = 8;
	
	AD8370_LE_POUT &= ~AD8370_LE;
	while (i-- > 0) {
		if ((data >> i) & 0x01) {
			AD8370_DATA_POUT |= AD8370_DATA;
		} else {
			AD8370_DATA_POUT &= ~AD8370_DATA;
		}
		AD8370_CLK_POUT |= AD8370_CLK;
		AD8370_CLK_POUT &= ~AD8370_CLK;
	}
	AD8370_LE_POUT |= AD8370_LE;
}

void ad8370_sw_spi_init(void) {
	AD8370_LE_POUT |= AD8370_LE;
	AD8370_LE_PDIR |= AD8370_LE;
	AD8370_CLK_POUT &= ~AD8370_CLK;
	AD8370_CLK_PDIR |= AD8370_CLK;
	AD8370_DATA_POUT &= ~AD8370_DATA;
	AD8370_DATA_PDIR |= AD8370_DATA;
}

void ad8370_config(void) {    
	ad8370_sw_spi_init();

    __delay_cycles(10000);
    // AV = Gaincode*Vernier*(1+(Pregain-1)*MSB)
    // 20dB: 10 = 23*0.055744 * (1+(7.79458-1)*1)
	ad8370_sw_spi_write(4);
}
