#ifndef ADF4252_H
#define ADF4252_H

#include <stdint.h>

void adf4252_config();

#define ADF4252_RF_FREQ		2566000000ULL
#define ADF4252_RF_REF_FREQ	20000000UL
#define ADF4252_RF_PFD_FREQ	20000000UL
#define ADF4252_IF_FREQ		270000000UL
#define ADF4252_IF_REF_FREQ	10000000UL
#define ADF4252_IF_PFD_FREQ	2000000UL
#define ADF4252_RSET		2700
#define ADF4252_RF_ICP		4.375e-3
#define ADF4252_IF_ICP		5.0e-3

#define ADF4252_R0_CB		0
#define ADF4252_R1_CB		1
#define ADF4252_R2_CB		2
#define ADF4252_R3_CB		3
#define ADF4252_R4_CB		4
#define ADF4252_R5_CB		5
#define ADF4252_R6_CB		6

/* Register 0
 * DB22:15	RF INT Value
 * DB14:3	RF FRAC Value
 */

#define ADF4252_INT			(ADF4252_RF_FREQ / ADF4252_RF_PFD_FREQ)
#define ADF4252_MOD			(4000)
#define ADF4252_FRAC		(((ADF4252_RF_FREQ - ADF4252_INT * ADF4252_RF_PFD_FREQ) * ADF4252_MOD) / ADF4252_RF_PFD_FREQ)

#define ADF4252_RF_N		(ADF4252_INT << 15)
#define ADF4252_RF_F		(ADF4252_FRAC << 3)

#define ADF4252_R0			(ADF4252_RF_N + ADF4252_RF_F + ADF4252_R0_CB)

/* Register 1
 * DB20         RF Prescaler
 * DB19		    RF REFIN Doubler
 * DB18:DB15	RF R Value
 * DB4:DB3	    MOD Value
 */

#define ADF4252_RF_PRE4		(ADF4252_RF_FREQ <= 1500000000UL)
#define ADF4252_RF_P		(((ADF4252_RF_PRE4) ? (unsigned long) 0 : (unsigned long) 1) << 20)

#define ADF4252_RF_REF2_OFF	((unsigned long) 0 << 19)
#define ADF4252_RF_REF2_ON	((unsigned long) 1 << 19)

#define ADF4252_RF_R		((ADF4252_RF_REF_FREQ / ADF4252_RF_PFD_FREQ) << 15)
#define ADF4252_RF_M		(ADF4252_MOD << 3)

#define ADF4252_R1			(ADF4252_RF_P + ADF4252_RF_REF2_ON + ADF4252_RF_R + ADF4252_RF_M + ADF4252_R1_CB)

/* Register 2
 * DB15		Noise and Spur Setting 3
 * DB11		Noise and Spur Setting 2
 * DB10:9   RF Current Setting
 * DB7      RF Phase Detector Polarity
 * DB6		Noise and Spur Setting 1
 * DB5      RF Power Down
 * DB4      RF CP 3State
 * DB3      RF Counter Reset
*/

#define ADF4252_NMODE_SPUR	0
#define ADF4252_NMODE_NSPUR	1
#define ADF4252_NMODE_NOISE	7
#define ADF4252_NMODE		ADF4252_NMODE_SPUR

#define ADF4252_N3			(((unsigned long) ADF4252_NMODE & 0x04) << 13)
#define ADF4252_N2			(((unsigned long) ADF4252_NMODE & 0x02) << 10)
#define ADF4252_N1			(((unsigned long) ADF4252_NMODE & 0x01) << 6)

#define ADF4252_ICP_MIN		(1.6875/ADF4252_RSET)
#define ADF4252_RF_CPI		((unsigned long) (ADF4252_RF_ICP/ADF4252_ICP_MIN-0.5) << 15)

#define ADF4252_RF_PDP_NEG		(0 << 7)
#define ADF4252_RF_PDP_POS		(1 << 7)

#define ADF4252_RF_PD_NORMAL	(0 << 5)
#define ADF4252_RF_PD_PWRDN		(1 << 5)

#define ADF4252_RF_CP_3ST_OFF	(0 << 4)
#define ADF4252_RF_CP_3ST_ON	(1 << 4)

#define ADF4252_RF_CNTRST_OFF	(0 << 3)
#define ADF4252_RF_CNTRST_ON	(1 << 3)

#define ADF4252_R2			(ADF4252_N3 + ADF4252_N2 + ADF4252_RF_CPI + ADF4252_RF_PDP_POS + ADF4252_N1 + \
							 ADF4252_RF_PD_NORMAL + ADF4252_RF_CP_3ST_OFF + ADF4252_RF_CNTRST_OFF + ADF4252_R2_CB)

/* Register 3
 * DB10:7	MUXOUT Setting
 * DB6		XO Disable
 * DB5		Power Down
 * DB4		CP 3State
 * DB3		Counter Reset
 */

#define ADF4252_MUX_LOW			((unsigned long) 0 << 7)
#define ADF4252_MUX_IF_ALD		((unsigned long) 1 << 7)
#define ADF4252_MUX_IF_RDIV		((unsigned long) 2 << 7)
#define ADF4252_MUX_IF_NDIV		((unsigned long) 3 << 7)
#define ADF4252_MUX_RF_ALD		((unsigned long) 4 << 7)
#define ADF4252_MUX_RFIF_ALD	((unsigned long) 5 << 7)
#define ADF4252_MUX_IF_DLD		((unsigned long) 6 << 7)
#define ADF4252_MUX_HI			((unsigned long) 7 << 7)
#define ADF4252_MUX_RF_RDIV		((unsigned long) 8 << 7)
#define ADF4252_MUX_RF_NDIV		((unsigned long) 9 << 7)
#define ADF4252_MUX_3ST			((unsigned long) 10 << 7)
#define ADF4252_MUX_RF_DLD		((unsigned long) 12 << 7)
#define ADF4252_MUX_RFIF_DLD	((unsigned long) 13 << 7)

#define ADF4252_XO_ON			(0 << 6)
#define ADF4252_XO_OFF			(1 << 6)

#define ADF4252_PD_NORMAL		(0 << 5)
#define ADF4252_PD_PWRDN		(1 << 5)

#define ADF4252_CP_3ST_OFF		(0 << 4)
#define ADF4252_CP_3ST_ON		(1 << 4)

#define ADF4252_CNTRST_OFF		(0 << 3)
#define ADF4252_CNTRST_ON		(1 << 3)

#define ADF4252_R3			(ADF4252_MUX_RFIF_DLD + ADF4252_XO_OFF + ADF4252_PD_NORMAL + \
							ADF4252_CP_3ST_OFF + ADF4252_CNTRST_OFF + ADF4252_R3_CB)

/* Register 4: IF N Divider
 * DB23		IF CP Gain
 * DB22:21	IF Prescaler
 * DB20:9	IF B Value
 * DB8:3	IF A Value
 */

#define ADF4252_CPG_NORM	((unsigned long) 0 << 23)
#define ADF4252_CPG_MAX		((unsigned long) 1 << 23)

/* TODO: check N to meet the P^2-P minimum division ratio requirement */
#define ADF4252_IF_PRE8		(ADF4252_IF_FREQ <= 1200000000UL)
#define ADF4252_IF_PRE16	(ADF4252_IF_FREQ <= 2400000000UL)
#define ADF4252_IF_PRE32	(ADF4252_IF_FREQ <= 4800000000UL)
#define ADF4252_IF_PRE		((ADF4252_IF_PRE8) ? 8 : ((ADF4252_IF_PRE16) ? 16 : ((ADF4252_IF_PRE32) ? 32 : 64)))
#define ADF4252_IF_P		((ADF4252_IF_PRE8) ? ((unsigned long) 0 << 21) : ((ADF4252_IF_PRE16) ? ((unsigned long) 1 << 21) : ((ADF4252_IF_PRE32) ? ((unsigned long) 2 << 21) : ((unsigned long) 3 << 21))))

#define ADF4252_IF_N		(ADF4252_IF_FREQ / ADF4252_IF_PFD_FREQ)
#define ADF4252_B_			(ADF4252_IF_N / ADF4252_IF_PRE)
#define ADF4252_A_			(ADF4252_IF_N - ADF4252_IF_PRE * ADF4252_B_)

#define ADF4252_A			(ADF4252_A_ << 3)
#define ADF4252_B			(ADF4252_B_ << 9)

#define ADF4252_R4			(ADF4252_CPG_NORM + ADF4252_IF_P + ADF4252_B + \
							ADF4252_A + ADF4252_CNTRST_OFF + ADF4252_R4_CB)

/* Register 5: IF R Divider
 * DB18		IF REFIN Doubler
 * DB17:3	IF R Value
 */

#define ADF4252_IF_REF2_OFF	((unsigned long) 0 << 18)
#define ADF4252_IF_REF2_ON	((unsigned long) 1 << 18)

#define ADF4252_IF_R		((ADF4252_IF_REF_FREQ / ADF4252_IF_PFD_FREQ) << 3)

#define ADF4252_R5			(ADF4252_IF_REF2_OFF + ADF4252_IF_R + ADF4252_R5_CB)

/* Register 6: IF Control
 * DB15,14,11	RF Phase Sync
 * DB10:8		IF CP Current Setting
 * DB7			IF PD Polarity
 * DB6			IF Lock Detect Precision
 * DB5			IF Power Down
 * DB4			IF CP Three-State
 * DB3			IF Counter Reset
 */

#define ADF4252_IF_CPI			((unsigned long) (ADF4252_IF_ICP/ADF4252_ICP_MIN-0.5) << 18)

#define ADF4252_IF_PDP_NEG		(0 << 7)
#define ADF4252_IF_PDP_POS		(1 << 7)

#define ADF4252_LDP_3			(0 << 6)
#define ADF4252_LDP_5			(1 << 6)

#define ADF4252_IF_PD_NORMAL	(0 << 5)
#define ADF4252_IF_PD_PWRDN		(1 << 5)

#define ADF4252_IF_CP_3ST_OFF	(0 << 4)
#define ADF4252_IF_CP_3ST_ON	(1 << 4)

#define ADF4252_IF_CNTRST_OFF	(0 << 3)
#define ADF4252_IF_CNTRST_ON	(1 << 3)

#define ADF4252_R6			(ADF4252_IF_CPI + ADF4252_IF_PDP_POS + ADF4252_LDP_5 + ADF4252_IF_PD_NORMAL + \
							 ADF4252_IF_CP_3ST_OFF + ADF4252_IF_CNTRST_OFF + ADF4252_R6_CB)

/* pin mapping */
#define ADF4252_CLK			BIT7
#define ADF4252_CLK_POUT	P1OUT
#define ADF4252_CLK_PDIR	P1DIR
#define ADF4252_DATA		BIT6
#define ADF4252_DATA_POUT	P1OUT
#define ADF4252_DATA_PDIR	P1DIR
#define ADF4252_LE			BIT5
#define ADF4252_LE_POUT		P1OUT
#define ADF4252_LE_PDIR		P1DIR

#endif // ADF4252_H
