#include "adf4360.h"
#include <msp430.h>
#include <inttypes.h>

void adf4360_sw_spi_write(uint32_t data) {
	int i = 24;
	
	ADF4360_LE_POUT &= ~ADF4360_LE;
	while (i-- > 0) {
		if ((data >> i) & 0x01) {
			ADF4360_DATA_POUT |= ADF4360_DATA;
		} else {
			ADF4360_DATA_POUT &= ~ADF4360_DATA;
		}
		ADF4360_CLK_POUT |= ADF4360_CLK;
		ADF4360_CLK_POUT &= ~ADF4360_CLK;
	}
	ADF4360_LE_POUT |= ADF4360_LE;
}

void adf4360_sw_spi_init(void) {
	ADF4360_LE_POUT |= ADF4360_LE;
	ADF4360_LE_PDIR |= ADF4360_LE;
	ADF4360_CLK_POUT &= ~ADF4360_CLK;
	ADF4360_CLK_PDIR |= ADF4360_CLK;
	ADF4360_DATA_POUT &= ~ADF4360_DATA;
	ADF4360_DATA_PDIR |= ADF4360_DATA;
}

void adf4360_config(void) {    
	adf4360_sw_spi_init();

    __delay_cycles(10000);

	adf4360_sw_spi_write(ADF4360_R1);
	adf4360_sw_spi_write(ADF4360_R0);

    __delay_cycles(10000);

	adf4360_sw_spi_write(ADF4360_R2_RX);
}

void adf4360_set_freq(int rx) {
	if (rx) {
		adf4360_sw_spi_write(ADF4360_R2_RX);
	} else {
		adf4360_sw_spi_write(ADF4360_R2_TX);
	}
}
