#include "adf4113.h"
#include <msp430.h>
#include <inttypes.h>

void adf4113_sw_spi_write(uint32_t data) {
	int i = 24;
	
	ADF4113_LE_POUT &= ~ADF4113_LE;
	while (i-- > 0) {
		if ((data >> i) & 0x01) {
			ADF4113_DATA_POUT |= ADF4113_DATA;
		} else {
			ADF4113_DATA_POUT &= ~ADF4113_DATA;
		}
		ADF4113_CLK_POUT |= ADF4113_CLK;
		ADF4113_CLK_POUT &= ~ADF4113_CLK;
	}
	ADF4113_LE_POUT |= ADF4113_LE;
}

void adf4113_sw_spi_init(void) {
	ADF4113_LE_POUT |= ADF4113_LE;
	ADF4113_LE_PDIR |= ADF4113_LE;
	ADF4113_CLK_POUT &= ~ADF4113_CLK;
	ADF4113_CLK_PDIR |= ADF4113_CLK;
	ADF4113_DATA_POUT &= ~ADF4113_DATA;
	ADF4113_DATA_PDIR |= ADF4113_DATA;
}

void adf4113_config(void) {
	const uint32_t r = 5;
	const uint32_t a = 12;
	const uint32_t b = 51;
	const uint32_t cpc = ADF4113_L2_CPC_560;

	adf4113_sw_spi_init();

	adf4113_sw_spi_write(ADF4113_L2_CTL + ADF4113_L2_MUXOUT_DLD + ADF4113_L2_PD_POL + cpc + ADF4113_L2_PRE_16_17 + ADF4113_L2_CPC_640);
	adf4113_sw_spi_write(ADF4113_L1_CTL + (a << ADF4113_L1_A_SHIFT) + (b << ADF4113_L1_B_SHIFT));
	adf4113_sw_spi_write(ADF4113_L0_CTL + ADF4113_L0_APB2 + (r << ADF4113_L0_REFCNT_SHIFT));
}

