/* 
 * 10 GHz transverter sequencer software
 *
 * pin definitions
 */

#define MS_DELAY_VALUE	70

/* 8 V for transmitter and TX switch on IF board, high active */
#define TX_8V		BIT4
#define TX_8V_POUT	P2OUT
#define TX_8V_PDIR	P2DIR

/* 8 V for receiver and RX switch + IF amplifier on IF board, high active */
#define RX_8V		BIT3
#define RX_8V_POUT	P2OUT
#define RX_8V_PDIR	P2DIR

/* 12 V for 1W power amplifier PCB, high active */
#define TX_PA_12V	BIT0
#define TX_PA_12V_POUT	P1OUT
#define TX_PA_12V_PDIR	P1DIR

/* pulse output for relay switch to TX, high active */
#define RLY_TX		BIT7
#define RLY_TX_POUT	P1OUT
#define RLY_TX_PDIR	P1DIR

/* pulse output for relay switch to RX, high active */
#define RLY_RX		BIT6
#define RLY_RX_POUT	P1OUT
#define RLY_RX_PDIR	P1DIR

/* TX allow output to IF transmitter, high active */
#define TX_ALLOW	BIT5
#define TX_ALLOW_POUT	P1OUT
#define TX_ALLOW_PDIR	P1DIR

/* PTT input from IF transmitter, high active */
#define PTT_IN		BIT4
#define PTT_IN_PIN	P1IN
#define PTT_IN_PDIR	P1DIR

/* PTT input pullup voltage output, high active */
#define PTT_VPU		BIT3
#define PTT_VPU_POUT	P1OUT
#define PTT_VPU_PDIR	P1DIR


