#include <msp430.h> 
#include "adf4001.h"
#include "adf4113.h"
#include "gps.h"

#define Bitime    208                       // ~ 9615 baud
#define DELTA     488                       // Target DCO = DELTA*(4096) ~2MHz

volatile unsigned char BitCnt;
volatile unsigned int RXTXData;

void Set_DCO(void);

/*
 * main.c
 */
int main(void) {
	WDTCTL = WDTPW | WDTHOLD;	// Stop watchdog timer
	gps_startup_delay();
  	Set_DCO();                                // Set DCO
	uart_init();
	gps_startup_delay();
	gps_startup_delay();
	gps_startup_delay();
	gps_startup_delay();
	gps_startup_delay();
	gps_disable_nmea_output();
	gps_startup_delay();
	gps_set_gps_only();
	gps_startup_delay();
	gps_enable_timepulse();
	gps_startup_delay();
	adf4001_config();
	adf4113_config();
	
	__bis_SR_register(LPM3_bits);
	
	while(1);
	


}

void Set_DCO (void)                         // Set DCO to selected frequency
{
  unsigned int Compare, Oldcapture = 0;

  BCSCTL1 |= DIVA_3;                        // ACLK= LFXT1CLK/8
  CCTL2 = CM_1 + CCIS_1 + CAP;              // CAP, ACLK
  TACTL = TASSEL_2 + MC_2 + TACLR;          // SMCLK, cont-mode, clear

  while(1)
  {
    while (!(CCIFG & CCTL2));               // Wait until capture occured
    CCTL2 &= ~CCIFG;                        // Capture occured, clear flag
    Compare = CCR2;                         // Get current captured SMCLK
    Compare = Compare - Oldcapture;         // SMCLK difference
    Oldcapture = CCR2;                      // Save current captured SMCLK

    if (DELTA == Compare) break;            // If equal, leave "while(1)"
    else if (DELTA < Compare)               // DCO is too fast, slow it down
    {
      DCOCTL--;
      if (DCOCTL == 0xFF)
      {
        if (!(BCSCTL1 == (XT2OFF + DIVA_3)))
        BCSCTL1--;                          // Did DCO roll under?, Sel lower RSEL
      }
    }
    else
    {
      DCOCTL++;
      if (DCOCTL == 0x00)
        {
          if (!(BCSCTL1 == (XT2OFF + DIVA_3 + 0x07)))
          BCSCTL1++;                        // Did DCO roll over? Sel higher RSEL
        }
    }
  }
  CCTL2 = 0;                                // Stop CCR2
  TACTL = 0;                                // Stop Timer_A
}

// Timer A0 interrupt service routine
#pragma vector=TIMERA0_VECTOR
//__interrupt void Timer_A0 (void)
void __attribute__ ((interrupt(TIMERA0_VECTOR))) Timer_A0 (void)
{
  CCR0 += Bitime;                           // Add Offset to CCR0
  if ( BitCnt == 0)
  	CCTL0 &= ~ CCIE;                        // All bits TXed, disable interrupt
  else
  {
      CCTL0 |=  OUTMOD2;                    // TX Space
      if (RXTXData & 0x01)
      CCTL0 &= ~ OUTMOD2;                   // TX Mark
      RXTXData = RXTXData >> 1;
      BitCnt --;
  }
}
